#ifndef LINUX_PCI_BACKPORT_TO_2_6_5_H
#define LINUX_PCI_BACKPORT_TO_2_6_5_H

#include_next <linux/pci.h>

#define PCI_EXP_DEVCTL		8	/* Device Control */
#define PCI_EXP_LNKCTL		16	/* Link Control */
#define  PCI_EXP_DEVCTL_READRQ  0x7000  /* Max_Read_Request_Size */
#define  PCI_EXP_DEVCTL_PAYLOAD	0x00e0	/* Max_Payload_Size */
#define PCI_EXP_LNKSTA		18	/* Link Status */
#define  PCI_CAP_ID_HT          0x08    /* HyperTransport */

struct msix_entry {
        u16     vector; /* kernel uses to write allocated vector */
        u16     entry;  /* driver uses to specify entry, OS writes */
};

static inline void pci_disable_msi(struct pci_dev* dev) {}
static inline void pci_disable_msix(struct pci_dev* dev) {}
static inline int pci_enable_msix(struct pci_dev* dev,
        struct msix_entry *entries, int nvec) {return -1;}

/*
 * pci_find_next_capability - Find next capability after current position
 * @dev: PCI device to query
 * @pos: Position to search from
 * @cap: capability code
 */
static inline int pci_find_next_capability(struct pci_dev *dev, u8 pos, int cap)
{
	u8 id;
	int ttl = 48;
	int ret;

	while (ttl--) {
		pci_read_config_byte(dev, pos + PCI_CAP_LIST_NEXT, &pos);
		pos &= ~3;
		if (pos < 0x40)
			break;
		pci_read_config_byte(dev, pos + PCI_CAP_LIST_ID, &id);
		if (id == 0xff)
			break;
		if (id == cap) {
			ret = pos;
			goto bail;
		}
	}

	ret = 0;

bail:
	return ret;
}

#endif
